//@include 'json.jsx'

function table_to_aoa(table) {
  var data = [];
  var cnt = table.rows.count();
  for(var R = 0; R < cnt; ++R) {
    var row = table.rows.item(R);
    data[R] = [];
    var ccnt = row.cells.count();
    for(var C = 0; C < ccnt; ++C) {
      var value = row.cells.item(C).contents;
      data[R][C] = value;
    }
  }
  return data;
}
function get_data() {
  var result = [];

  var tfcnt = app.activeDocument.textFrames.count();
  for(var i = 0; i < tfcnt; ++i) {
    var tf = app.activeDocument.textFrames.item(i);
    var tcnt = tf.tables.count();
    if(tcnt == 0) continue;
    for(var j = 0; j < tcnt; ++j) result.push(table_to_aoa(tf.tables.item(j)));
  }
  return JSON.lave(result);
}

function aoa_to_table(data, table) {
  var cnt = Math.min(data.length, table.rows.count());
  for(var R = 0; R < cnt; ++R) {
    var ROW = data[R], row = table.rows.item(R);
    var ccnt = Math.min(row.cells.count(), ROW.length);
    for(var C = 0; C < ccnt; ++C) {
      row.cells.item(C).contents = String(ROW[C])
    }
  }
}
function set_data(data) {
  try {
    var tf = app.activeDocument.textFrames.itemByName("Table Frame");
    var cnt = 0;
    for(var R = 0; R < data.length; ++R) cnt = Math.max(cnt, (data[R]||[]).length);
    if(tf.tables.count() == 0) tf.tables.add({
      headerRowCount: 1,
      bodyRowCount: data.length - 1,
      columnCount: cnt
    });
    aoa_to_table(data, tf.tables.item(0));
    return "success";
  } catch(e) { return String(e.message || e); }
}
